# Microcode

## Address bus

Length: 24 bit (3 byte)

```
* 23 OP/I  (CU)
* 22 PC/I  (PC)
* 21 PC/O  (PC)
* 20 +1    (PC)
* 19 AR/I  (RAM)
* 18 R     (RAM)
* 17 W     (RAM)
* 16 DR/I  (RAM)

* 15 DR/O  (RAM)
* 14 BM    (Branch Mode Flag *)
* 13 I/CLR (Clear I/O buffer *)
* 12 1     (ALU)
* 11 OP3   (ALU)
* 10 OP2   (ALU / CCR when BM set)
* 09 OP1   (ALU / CCR when BM set)
* 08 OP0   (ALU / CCR when BM set)

* 07 AX/I  (AX)
* 06 AX/O  (AX)
* 05 BX/I  (BX)
* 04 BX/O  (BX)
* 03 SP/I  (SP)
* 02 SP/O  (SP)
* 01 Z/I   (Z)
* 00 Z/O   (Z)
```

## Instructions

```
$00 $280000 001010000000000000000000 AR := PC ; fetch addr
$01 $050000 000001010000000000000000 DR := {AR}
$02 $908000 100100001000000000000000 OP := DR & PC := PC+1
$03 $280000 001010000000000000000000 AR := PC ; fetch op
$04 $150000 000101010000000000000000 DR := {AR} & PC := PC+1
$05 $ffffff 111111111111111111111111 ; decode

$06 $008080 000000001000000010000000 [lda #$nn] AX := DR
$07 $000000 000000000000000000000000 ; execute

$08 $088000 000010001000000000000000 [lda $nn] AR := DR
$09 $050000 000001010000000000000000 DR := {AR}
$0a $008080 000000001000000010000000 AX := DR
$0b $000000 000000000000000000000000 ; execute

$0c $088000 000010001000000000000000 [lda ($nn)] AR := DR
$0d $050000 000001010000000000000000 DR := {AR}
$0e $088000 000010001000000000000000 AR := DR
$0f $050000 000001010000000000000000 DR := {AR}
$10 $008080 000000001000000010000000 AX := DR
$11 $000000 000000000000000000000000 ; execute

$12 $008020 000000001000000000100000 [ldb #$nn] BX := DR
$13 $000000 000000000000000000000000 ; execute

$14 $088000 000010001000000000000000 [ldb $nn] AR := DR
$15 $050000 000001010000000000000000 DR := {AR}
$16 $008020 000000001000000000100000 BX := DR
$17 $000000 000000000000000000000000 ; execute

$18 $088000 000010001000000000000000 [ldb ($nn)] AR := DR
$19 $050000 000001010000000000000000 DR := {AR}
$1a $088000 000010001000000000000000 AR := DR
$1b $050000 000001010000000000000000 DR := {AR}
$1c $008020 000000001000000000100000 BX := DR
$1d $000000 000000000000000000000000 ; execute

$1e $088000 000010001000000000000000 [ldb ($nn),a] AR := DR
$1f $050000 000001010000000000000000 DR := {AR}
$20 $008002 000000001000000000000010 Z := AX + DR
$21 $080001 000010000000000000000001 AR := Z
$22 $050000 000001010000000000000000 DR := {AR}
$23 $008020 000000001000000000100000 BX := DR
$24 $000000 000000000000000000000000 ; execute

$25 $008002 000000001000000000000010 [ldb ($nn,a)] Z := DR + AX
$26 $080001 000010000000000000000001 AR := Z
$27 $050000 000001010000000000000000 DR := {AR}
$28 $088000 000010001000000000000000 AR := DR
$29 $050000 000001010000000000000000 DR := {AR}
$2a $008020 000000001000000000100000 BX := DR
$2b $000000 000000000000000000000000 ; execute

$2c $088000 000010001000000000000000 [sta $nn] AR := DR
$2d $010040 000000010000000001000000 DR := AX
$2e $028000 000000101000000000000000 {AR} := DR
$2f $000000 000000000000000000000000 ; execute

$30 $088000 000010001000000000000000 [sta ($nn)] AR := DR
$31 $050000 000001010000000000000000 DR := {AR}
$32 $088000 000010001000000000000000 AR := DR
$33 $050000 000001010000000000000000 DR := {AR}
$34 $008080 000000001000000010000000 AX := DR
$35 $000000 000000000000000000000000 ; execute

$36 $008002 000000001000000000000010 [stb $nn,a] Z := DR + AX
$37 $080001 000010000000000000000001 AR := Z
$38 $010010 000000010000000000010000 DR := BX
$39 $028000 000000101000000000000000 {AR} := DR
$3a $000000 000000000000000000000000 ; execute

$3b $088000 000010001000000000000000 [stb $nn] AR := DR
$3c $010010 000000010000000000010000 DR := BX
$3d $028000 000000101000000000000000 {AR} := DR
$3e $000000 000000000000000000000000 ; execute

$3f $088000 000010001000000000000000 [stb ($nn)] AR := DR
$40 $050000 000001010000000000000000 DR := {AR}
$41 $088000 000010001000000000000000 AR := DR
$42 $050000 000001010000000000000000 DR := {AR}
$43 $008020 000000001000000000100000 BX := DR
$44 $000000 000000000000000000000000 ; execute

$45 $088000 000010001000000000000000 [stb ($nn),a] AR := DR
$46 $050000 000001010000000000000000 DR := {AR}
$47 $008002 000000001000000000000010 Z := AX + DR
$48 $080001 000010000000000000000001 AR := Z
$49 $010010 000000010000000000010000 DR := BX
$4a $028000 000000101000000000000000 {AR} := DR
$4b $000000 000000000000000000000000 ; execute

$4c $008002 000000001000000000000010 [stb ($nn,a)] Z := DR + AX
$4d $080001 000010000000000000000001 AR := Z
$4e $050000 000001010000000000000000 DR := {AR}
$4f $088000 000010001000000000000000 AR := DR
$50 $010010 000000010000000000010000 DR := BX
$51 $028000 000000101000000000000000 {AR} := DR
$52 $000000 000000000000000000000000 ; execute

$53 $000060 000000000000000001100000 [tab] BX := AX
$54 $000000 000000000000000000000000 ; execute

$55 $000090 000000000000000010010000 [tba] AX := BX
$56 $000000 000000000000000000000000 ; execute

$57 $008002 000000001000000000000010 [adc #$nn] Z := AX + DR
$58 $000081 000000000000000010000001 AX := Z
$59 $000000 000000000000000000000000 ; execute

$5a $088000 000010001000000000000000 [adc $nn] AR := DR
$5b $050000 000001010000000000000000 DR := {AR}
$5c $008002 000000001000000000000010 Z := AX + DR
$5d $000081 000000000000000010000001 AX := Z
$5e $000000 000000000000000000000000 ; execute

$5f $008102 000000001000000100000010 [sbc #$nn] Z := AX - DR
$60 $000081 000000000000000010000001 AX := Z
$61 $000000 000000000000000000000000 ; execute

$62 $088000 000010001000000000000000 [sbc $nn] AR := DR
$63 $050000 000001010000000000000000 DR := {AR}
$64 $008102 000000001000000100000010 Z := AX - DR
$65 $000081 000000000000000010000001 AX := Z
$66 $000000 000000000000000000000000 ; execute

$67 $001002 000000000001000000000010 [inc] Z := AX + 1
$68 $000081 000000000000000010000001 AX := Z
$69 $000000 000000000000000000000000 ; execute

$6a $001102 000000000001000100000010 [dec] Z := AX - 1
$6b $000081 000000000000000010000001 AX := Z
$6c $000000 000000000000000000000000 ; execute

$6d $008202 000000001000001000000010 [and #$nn] Z = AX AND DR
$6e $000081 000000000000000010000001 AX := Z
$6f $000000 000000000000000000000000 ; execute

$70 $088000 000010001000000000000000 [and $nn] AR := DR
$71 $050000 000001010000000000000000 DR := {AR}
$72 $008202 000000001000001000000010 Z := AX AND DR
$73 $000081 000000000000000010000001 AX := Z
$74 $000000 000000000000000000000000 ; execute

$75 $008302 000000001000001100000010 [ora #$nn] Z = AX OR DR
$76 $000081 000000000000000010000001 AX := Z
$77 $000000 000000000000000000000000 ; execute

$78 $088000 000010001000000000000000 [ora $nn] AR := DR
$79 $050000 000001010000000000000000 DR := {AR}
$7a $008302 000000001000001100000010 Z := AX OR DR
$7b $000081 000000000000000010000001 AX := Z
$7c $000000 000000000000000000000000 ; execute

$7d $008402 000000001000010000000010 [eor #$nn] Z = AX XOR DR
$7e $000081 000000000000000010000001 AX := Z
$7f $000000 000000000000000000000000 ; execute

$80 $088000 000010001000000000000000 [eor $nn] AR := DR
$81 $050000 000001010000000000000000 DR := {AR}
$82 $008402 000000001000010000000010 Z := AX XOR DR
$83 $000081 000000000000000010000001 AX := Z
$84 $000000 000000000000000000000000 ; execute

$85 $000502 000000000000010100000010 [lsl] Z = AX LSL
$86 $000081 000000000000000010000001 AX := Z
$87 $000000 000000000000000000000000 ; execute

$88 $000602 000000000000011000000010 [lsr] Z = AX LSR
$89 $000081 000000000000000010000001 AX := Z
$8a $000000 000000000000000000000000 ; execute

$8b $000702 000000000000011100000010 [asl] Z = AX ASL
$8c $000081 000000000000000010000001 AX := Z
$8d $000000 000000000000000000000000 ; execute

$8e $000802 000000000000100000000010 [rol] Z = AX ROL
$8f $000081 000000000000000010000001 AX := Z
$90 $000000 000000000000000000000000 ; execute

$91 $000902 000000000000100100000010 [ror] Z = AX ROR
$92 $000081 000000000000000010000001 AX := Z
$93 $000000 000000000000000000000000 ; execute

$94 $004000 000000000100000000000000 [bpl]
$95 $000000 000000000000000000000000 ; execute

$96 $004100 000000000100000100000000 [bmi]
$97 $000000 000000000000000000000000 ; execute

$98 $004200 000000000100001000000000 [bcc]
$99 $000000 000000000000000000000000 ; execute

$9a $004300 000000000100001100000000 [bcs]
$9b $000000 000000000000000000000000 ; execute

$9c $004400 000000000100010000000000 [bne]
$9d $000000 000000000000000000000000 ; execute

$9e $004500 000000000100010100000000 [beq]
$9f $000000 000000000000000000000000 ; execute

$a0 $004600 000000000100011000000000 [sec]
$a1 $000000 000000000000000000000000 ; execute

$a2 $004700 000000000100011100000000 [clc]
$a3 $000000 000000000000000000000000 ; execute

$a4 $008102 000000001000000100000010 [cmp #$nn] Z := AX - DR
$a5 $000000 000000000000000000000000 ; execute

$a6 $088000 000010001000000000000000 [cmp $nn] AR := DR
$a7 $050000 000001010000000000000000 DR := {AR}
$a8 $008102 000000001000000100000010 Z := AX - DR
$a9 $000000 000000000000000000000000 ; execute

$aa $080004 000010000000000000000100 [pha] AR := SP
$ab $010040 000000010000000001000000 DR := AX
$ac $028000 000000101000000000000000 {AR} := DR
$ad $000084 000000000000000010000100 AX := SP
$ae $001002 000000000001000000000010 Z := AX + 1
$af $000009 000000000000000000001001 SP := Z
$b0 $008080 000000001000000010000000 AX := DR
$b1 $000000 000000000000000000000000 ; execute

$b2 $000084 000000000000000010000100 [pop] AX := SP
$b3 $001102 000000000001000100000010 Z = AX - 1
$b4 $080009 000010000000000000001001 SP := Z & AR := Z
$b5 $050000 000001010000000000000000 DR := {AR}
$b6 $008080 000000001000000010000000 AX := DR
$b7 $000000 000000000000000000000000 ; execute

$b8 $400000 010000000000000000000000 [jmp #$nn] PC := DR
$b9 $000000 000000000000000000000000 ; execute

$ba $088000 000010001000000000000000 [jmp $nn] AR := DR
$bb $050000 000001010000000000000000 DR := {AR}
$bc $400000 010000000000000000000000 PC := DR
$bd $000000 000000000000000000000000 ; execute

$be $008080 000000001000000010000000 [jsr #$nn] AX := DR ; keep operand
$bf $080004 000010000000000000000100 AR := SP ; save sp
$c0 $210000 001000010000000000000000 DR := PC
$c1 $028000 000000101000000000000000 {AR} := DR
$c2 $010040 000000010000000001000000 DR := AX ; change pc
$c3 $400000 010000000000000000000000 PC := DR
$c4 $000084 000000000000000010000100 AX := SP ; increase sp
$c5 $001002 000000000001000000000010 Z := AX + 1
$c6 $000009 000000000000000000001001 SP := Z
$c7 $000000 000000000000000000000000 ; execute

$c8 $088000 000010001000000000000000 [jsr $nn] AR := DR ; read jump address
$c9 $050000 000001010000000000000000 DR := {AR}
$ca $200080 001000000000000010000000 AX := PC ; store pc
$cb $400000 010000000000000000000000 PC := DR ; jump to address
$cc $010040 000000010000000001000000 DR := AX
$cd $080084 000010000000000010000100 AR := SP & AX := SP
$ce $001002 000000000001000000000010 Z := AX + 1
$cf $000009 000000000000000000001001 SP := Z
$d0 $000000 000000000000000000000000 ; execute

$d1 $000084 000000000000000010000100 [rts] AX := SP
$d2 $001102 000000000001000100000010 Z := AX - 1
$d3 $080009 000010000000000000001001 SP := Z & AR := Z
$d4 $050000 000001010000000000000000 DR := {AR}
$d5 $400000 010000000000000000000000 PC := DR
$d6 $000000 000000000000000000000000 ; execute

$d7 $002000 000000000010000000000000 [cib] ; clear input buffer
$d8 $000000 000000000000000000000000 ; execute

$d9 $008002 000000001000000000000010 [ldb $nn,a] Z := DR + AX
$da $080001 000010000000000000000001 AR := Z
$db $050000 000001010000000000000000 DR := {AR}
$dc $008020 000000001000000000100000 BX := DR
$dd $000000 000000000000000000000000 ; execute
```
